<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:m1="http://www.sec.gov/edgar/sdrfiler"
	xmlns:ns1="http://www.sec.gov/edgar/common" xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/statecodes" xmlns:ns3="http://www.sec.gov/edgar/sdrcommon">

	<!-- Item 3 templates -->
	<xsl:template name="Item3">
		<h3>
			<em>General Information (8-11)
			</em>
		</h3>
		<xsl:call-template name="generalInfo2" />
	</xsl:template>

	<xsl:template name="generalInfo2">
		<table role="presentation" >
			<tr>
				<h4>
					<em>8. Applicant Category:</em>
				</h4>
			</tr>
			<tr>
				<td class="label">
					Applicant is a:
				</td>
				<td>
					<span class="yesNo">
						<xsl:choose>
							<xsl:when
								test="count(m1:generalInfo/m1:applicantCategory/m1:applicantType) &gt; 0">
								<xsl:choose>
									<xsl:when
										test="string(m1:generalInfo/m1:applicantCategory/m1:applicantType) = 'Corporation'">
										<img src="Images/radio-checked.jpg" alt="Radio button checked" />
										Corporation
										<img src="Images/radio-unchecked.jpg" alt="Radio button not checked" />
										Partnership
										<img src="Images/radio-unchecked.jpg" alt="Radio button not checked" />
										Other Form of Organization
									</xsl:when>
								</xsl:choose>
								<xsl:choose>
									<xsl:when
										test="string(m1:generalInfo/m1:applicantCategory/m1:applicantType) = 'Partnership'">
										<img src="Images/radio-unchecked.jpg" alt="Radio button not checked" />
										Corporation
										<img src="Images/radio-checked.jpg" alt="Radio button checked" />
										Partnership
										<img src="Images/radio-unchecked.jpg" alt="Radio button not checked" />
										Other Form of Organization
									</xsl:when>
								</xsl:choose>
								<xsl:choose>
									<xsl:when
										test="string(m1:generalInfo/m1:applicantCategory/m1:applicantType) = 'Other Form of Organization'">
										<img src="Images/radio-unchecked.jpg" alt="Radio button not checked" />
										Corporation
										<img src="Images/radio-unchecked.jpg" alt="Radio button not checked" />
										Partnership
										<img src="Images/radio-checked.jpg" alt="Radio button checked" />
										Other Form of Organization
									</xsl:when>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked" />
								Corporation
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked" />
								Partnership
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked" />
								Other Form of Organization
							</xsl:otherwise>
						</xsl:choose>
					</span>
				</td>
			</tr>
			<xsl:choose>
				<xsl:when
					test="string(m1:generalInfo/m1:applicantCategory/m1:applicantType) = 'Other Form of Organization'">
					<tr>
						<td class="label">Specify:
						</td>
						<td>
							<p>
								<div class="fakeBox3">
									<xsl:value-of
										select="string(m1:generalInfo/m1:applicantCategory/m1:applicantTypeOtherDesc)" />
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</p>
						</td>
					</tr>
				</xsl:when>
			</xsl:choose>
			<tr>
				<td class="label">
					Request Confidentiality:
				</td>
				<td>
					<xsl:choose>
						<xsl:when
							test="string(m1:generalInfo/m1:applicantCategory/m1:applcntTypeConfFlag) = 'true'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>

		<xsl:if
			test="(m1:generalInfo/m1:applicantCategory/m1:applicantType) = 'Corporation' 
			or (m1:generalInfo/m1:applicantCategory/m1:applicantType) = 'Other Form of Organization'">
			<table role="presentation" >
				<tr>
					<h4>
						<em>9. If the applicant is a corporation or other form of
							organization (besides a partnership):
						</em>
					</h4>
				</tr>
				<tr>
					<td class="label">a. Date of incorporation or organization:
					</td>
					<td>
						<p>
							<div class="fakeBox2">
								<xsl:value-of
									select="string(m1:generalInfo/m1:corpOrgInfo/m1:dateOfCoperationOrg)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label">b. Place of incorporation or state/country of
						organization:
					</td>
					<td>
						<p>
							<div class="fakeBox">
								<xsl:call-template name="stateDescription">
									<xsl:with-param name="stateCode"
										select="./m1:generalInfo/m1:corpOrgInfo/m1:stateCorperationOrOrg" />
								</xsl:call-template>
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label">
						Request Confidentiality:
					</td>
					<td>
						<xsl:choose>
							<xsl:when
								test="string(m1:generalInfo/m1:corpOrgInfo/m1:corprtnOrgConfFlag) = 'true'">
								<img src="Images/box-checked.jpg" alt="Checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
			</table>
		</xsl:if>

		<xsl:if
			test="string(m1:generalInfo/m1:applicantCategory/m1:applicantType) = 'Partnership'">
			<table role="presentation" >
				<tr>
					<h4>
						<em>10. If the applicant is a partnership:
						</em>
					</h4>
				</tr>
				<tr>
					<td class="label">a. Date of filing of partnership agreement:
					</td>
					<td>
						<p>
							<div class="fakeBox">
								<xsl:value-of
									select="string(m1:generalInfo/m1:partnershipInfo/m1:filingPartnershipDate)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label">b. Place where partnership agreement was filed:
					</td>
					<td>
						<p>
							<div class="fakeBox">
								<xsl:value-of
									select="string(m1:generalInfo/m1:partnershipInfo/m1:placeOfPartnershipAgreement)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label">
						Request Confidentiality:
					</td>
					<td>
						<xsl:choose>
							<xsl:when
								test="string(m1:generalInfo/m1:partnershipInfo/m1:filingPrtnrConfFlag) = 'true'">
								<img src="Images/box-checked.jpg" alt="Checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
			</table>
		</xsl:if>

		<table role="presentation" >
			<tr>
				<h4>
					<em>11. Applicant understands and consents that any notice or
						service of process, pleadings, or other documents in connection
						with any action or proceeding against the applicant may be
						effectuated by certified mail to the officer specified or person
						named below at the U.S. address given. Such officer or person
						cannot be a Commission member, official, or employee.
					</em>
				</h4>
			</tr>
			<tr>
				<td class="label">Name of Person or, if Applicant is a Corporation, Title
					of Officer:
				</td>
				<td>
					<p>
						<div class="fakeBox3">
							<xsl:value-of
								select="string(m1:generalInfo/m1:consentName/m1:personNameOrOfficerTitle)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					</p>
				</td>
			</tr>
			<tr>
				<td class="label">Name of Applicant or Applicable Entity:
				</td>
				<td>
					<p>
						<div class="fakeBox3">
							<xsl:value-of
								select="string(m1:generalInfo/m1:consentName/m1:applicantNameOrApplcblEntity)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					</p>
				</td>
			</tr>
			<tr>
				<td class="label">
					Request Confidentiality:
				</td>
				<td>
					<xsl:choose>
						<xsl:when
							test="string(m1:generalInfo/m1:consentName/m1:consentNameConfFlag) = 'true'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>

		<table role="presentation" >
			<tr>
				<td class="label">Address 1 </td>
				<td>
					<p>
						<div class="fakeBox">
							<xsl:value-of
								select="string(m1:generalInfo/m1:consentAddress/m1:street1)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					</p>
				</td>
			</tr>
			<tr>
				<td class="label">Address 2 </td>
				<td>
					<p>
						<div class="fakeBox">
							<xsl:value-of
								select="string(m1:generalInfo/m1:consentAddress/m1:street2)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					</p>
				</td>
			</tr>
			<tr>
				<td class="label">City </td>
				<td>
					<p>
						<div class="fakeBox">
							<xsl:value-of select="string(m1:generalInfo/m1:consentAddress/m1:city)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					</p>
				</td>
			</tr>
			<tr>
				<td class="label">State/Country   </td>
				<td>
					<p>
						<div class="fakeBox">
							<xsl:call-template name="stateDescription">
								<xsl:with-param name="stateCode"
									select="string(./m1:generalInfo/m1:consentAddress/m1:stateCountry)" />
							</xsl:call-template>
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					</p>
				</td>
			</tr>
			<tr>
				<td class="label">Mailing Zip/ Postal Code  </td>
				<td>
					<p>
						<div align="left">
							<div class="fakeBox2">
								<xsl:value-of
									select="string(m1:generalInfo/m1:consentAddress/m1:zipCode)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</div>
					</p>
				</td>
			</tr>
			<tr>
				<td class="label">
					Request Confidentiality:
				</td>
				<td>
					<xsl:choose>
						<xsl:when
							test="string(m1:generalInfo/m1:consentAddress/m1:consentAddressConfFlag) = 'true'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>

		<table role="presentation" >
			<tr>
				<td class="label">Telephone Number:  </td>
				<td>
					<p>
						<div align="left">
							<div class="fakeBox2">
								<xsl:value-of select="string(m1:generalInfo/m1:consentPhone/m1:phone)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</div>
					</p>
				</td>
			</tr>
			<tr>
				<td class="label">
					Request Confidentiality:
				</td>
				<td>
					<xsl:choose>
						<xsl:when
							test="string(m1:generalInfo/m1:consentPhone/m1:consentPhoneConfFlag) = 'true'">
							<img src="Images/box-checked.jpg" alt="Checkbox is checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>